/*-----------------------------------------------------------------------------------------------------------------------------
FileName: XYDetector.c 
Autors: Mathieu Gisselbrecht
Date : Creation -  Avril 2006
-----------------------------------------------------------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------------------------------------------------------
// PROJECT INCLUDE 
//-----------------------------------------------------------------------------------------------------------------------------
#include "igorTools.h"
#include "particleDetector.h"
#include "XYDetector.h"

//-----------------------------------------------------------------------------------------------------------------------------
// All structures are 2-byte-aligned.
#if TARGET_CPU_PPC
	#pragma options align=mac68k
#endif
#ifdef _WINDOWS_
	#pragma pack(2)
#endif

//-----------------------------------------------------------------------------------------------------------------------------
// MISC #DEFINEs
//-----------------------------------------------------------------------------------------------------------------------------
#pragma mark Defines


//-----------------------------------------------------------------------------------------------------------------------------
// LOCAL VARIABLES
//-----------------------------------------------------------------------------------------------------------------------------
#pragma mark Local Variables 

//-----------------------------------------------------------------------------------------------------------------------------
// LOCAL PROTOTYPES 
//-----------------------------------------------------------------------------------------------------------------------------
#pragma mark Local Prototypes 

static void scqs3(long n, long *ra, long *rb, long *rc);
static short analyzeXYEvent(TDetector *Detector);

//-----------------------------------------------------------------------------------------------------------------------------
//  									  				COMMON CODE 
//-----------------------------------------------------------------------------------------------------------------------------
#pragma mark ----------------------------
//-----------------------------------------------------------------------------------------------------------------------------
static void scqs3(long n, long *ra,  long *rb,  long *rc) 
/* Tri en fonction de ra ( rb, rc , rd et re suivent ) */
{
	long l,j,ir,i;
	unsigned int  rra;
	unsigned char rrb, rrc;

	if (n <2) return;		
	ra -= 1; rb -= 1; rc -= 1;
	
	l=(n>>1)+1;
	ir=n;
	for(;;) {
		if (l>1) {	rra=ra[--l]; 	rrb=rb[l]; 	rrc=rc[l];}
		else {		rra=ra[ir];	rrb=rb[ir];	rrc=rc[ir];
				ra[ir]=ra[1];	rb[ir]=rb[1];	rc[ir]=rc[1];
			if (--ir == 1) {
					ra[1] = rra;	rb[1] = rrb;	rc[1] = rrc;return;}
		}
		i=l;
		j = l<<1;
		while (j<=ir) 	{
			if (j < ir && ra[j] < ra[j+1]) ++j;
			if (rra< ra[j]) {
					ra[i]=ra[j];	rb[i]=rb[j];	rc[i]=rc[j];	j+= (i=j);
			}
			else j=ir+1;
			}
					ra[i] = rra;	rb[i] = rrb;	rc[i] = rrc;
	}
}
//-----------------------------------------------------------------------------------------------------------------------------
#pragma mark ----------------------------
//-----------------------------------------------------------------------------------------------------------------------------
void InitXYEvent(TDetector *Detector)
{
	TXYDetector *XYDetector=(TXYDetector*)Detector->device;
	TXYEvent *Event=&XYDetector->Event;

	XYDetector->refTdc=NB_CANAUX_TEMPORELS;
	Event->nx=0;
	Event->ny=0;
	Event->nxy=0;
}

//-----------------------------------------------------------------------------------------------------------------------------
short addXYEvent(TDetector *Detector, long tdcTime, long tdcChannel)
{
	TXYDetector *XYDetector=(TXYDetector*)Detector->device;
 	long *refTdc=&XYDetector->refTdc; 
	TXYEvent *Event=&XYDetector->Event;
	long *nx= &Event->nx;
	long *ny= &Event->ny; 
	long *nxy=&Event->nxy;
	long *channelx = Event->channelx;
	long *channely = Event->channely; 
 	long *time=Event->time;

	long numDS16, numChannel, anode, isYdata;
	
	// stop in case of incoherent data
	if (!((tdcChannel>=0)&&(tdcChannel<=NB_XY_CHANNEL))) return -1; 
	if (!((tdcTime>=0)&&(tdcTime<=NB_CANAUX_TEMPORELS))) return -1;

	// Check time reference channel and return; or add hit
	switch (XYDetector->ref) {
		case 1:
				if (tdcChannel==XYDetector->ch[0]) {
					if (*refTdc>tdcTime) *refTdc=tdcTime;
					return 0;
				}
			break;
		case 2:
				if (tdcChannel==XYDetector->ch[1]) {
					if (*refTdc>tdcTime) *refTdc=tdcTime;
					return 0;
				}
			break;
		case 3:
				if (tdcChannel==XYDetector->ch[0]) {
					if (*refTdc>tdcTime) *refTdc=tdcTime;
					return 0;
					}
				if (tdcChannel!=XYDetector->ch[1]) return 0; 
			break;
		case 4:
				if (tdcChannel==XYDetector->ch[1]) {
					if (*refTdc>tdcTime) *refTdc=tdcTime;
					return 0;
					}
				if (tdcChannel==XYDetector->ch[0]) return 0; 			
			break;						
	}
	
	// Get reference from detector: DS16number, anode type (nested or not),  time of flight
	numDS16 = (Event->numDS16Bits&tdcChannel)>>4; 		// Fetch th number of DS16  : mask 0x30 for CIEL 1
	XYDetector->DS16Area[numDS16] +=1;					// Store all hits/DS16 for threshold calibration	
	// correct time from hardware (delay between channels)
 	tdcTime	=abs(tdcTime-XYDetector->channelOffset[tdcChannel&0xF][numDS16]-XYDetector->DS16Offset[numDS16]);		
	// correct channel from hardware (the case of nested line)
 	anode=XYDetector->anode;
 	if (anode) {	
 		if (tdcChannel>=anode) {
			tdcChannel-=anode;
			tdcChannel=2*tdcChannel+1;
			}
		else
			tdcChannel=2*tdcChannel;
	}
	
	// Add hit and refresh raw image
	numChannel	 = Event->numChannelBits&tdcChannel;		// 0x1f for CIEL 1
 	isYdata 	 = Event->xyBit;								// 0x20 for CIEL 1

	time[*(nxy)]=tdcTime;	
	if (isYdata&tdcChannel) {
		channelx[*(nxy)]=0;	  
		channely[*(nxy)]=numChannel+1; // increment of 1 !!!
		*(ny)+=1;
		} 
	else {	
		channelx[*(nxy)]=numChannel+1; 
		channely[*(nxy)]=0;		   	
		*(nx)+=1;
		}
	*(nxy)+=1;				
								
 	return 0;
}
//-----------------------------------------------------------------------------------------------------------------------------
short correctXYEvent(TDetector *Detector)
{	
 	long tof_offset=Detector->tof_offset;
 	long *tof= 	 Detector->tof;
 	long *projX= Detector->projX;
 	long *projY= Detector->projY;
	TXYDetector *XYDetector=(TXYDetector*)Detector->device;
 	long time_ref=XYDetector->refTdc;
 	long correct_time=XYDetector->ref;
	TXYEvent *Event=&XYDetector->Event;
	long *channelx = Event->channelx;
	long *channely = Event->channely; 	
	long isYdata=Event->xyBit;
	long nxy=Event->nxy;
 	long *time=Event->time;
	long cxi, cyi, i, j;

	if ((correct_time)&&(time_ref==NB_CANAUX_TEMPORELS)) return -1;
	for(i=0; i<nxy; i++) {
		if (correct_time) time[i]=abs(time[i]-time_ref-tof_offset);
		else time[i]=abs(time[i]-tof_offset);
		tof[time[i]]+=1;
		cxi=channelx[i];
		cyi=channely[i];		
		if (cxi) {
				projX[cxi]+=1;
				for (j=0;j<isYdata;j++) Detector->image[cxi+(j*isYdata)]+=1;
			}
		if (cyi) {
				projY[cyi]+=1;
				for (j=0;j<isYdata;j++) Detector->image[j+(cyi*isYdata)]+=1;
			}
		}
		
	return 0;
}

//-----------------------------------------------------------------------------------------------------------------------------
short localizedXYEvent(TDetector *Detector)
{ 	
	
  	long  *nTimeGroups = &Detector->nTimeGroups; 
	float *xMoyen = Detector->xMoyen;
	float *yMoyen = Detector->yMoyen;	
  	float *MeanTimeofGroup = Detector->MeanTimeofGroup;	
  	TXYDetector *XYDetector=(TXYDetector*)Detector->device;
  	long deadtime=XYDetector->deltaT;	
	TXYEvent *Event=&XYDetector->Event;
 	long nx			= Event->nx;
	long ny			= Event->ny;
 	long nxy		= Event->nxy;
 	long *channelx  = Event->channelx;
 	long *channely	= Event->channely;
 	long *time	 	= Event->time;

 	long i;
	float xm, ym;
	
	*(nTimeGroups)=0;					// By default no group is found
	if (nxy==0) return -1; 				// No hit for this detector
	if (nx*ny ==0) return 0; 			// At least one hit for X and one hit for Y is required

	switch (nxy) {
		case 0:
			break;
		case 1:
			break;					
		case 2:		// Two hits found -> coincidence order =1
			if(abs(time[0]-time[1])>deadtime) return 0;  
			*(nTimeGroups) = 1;			
			MeanTimeofGroup[0] = 0.5*(time[0]+time[1]);
			if(channelx[0]!=0)  { xMoyen[0] = channelx[0];  yMoyen[0] = (float)channely[1];}
			else 				{ xMoyen[0] = channelx[1];  yMoyen[0] = (float)channely[0];}
			XYDetector->nbHits[*(nTimeGroups)][nxy]+=1;		// Save hit distribution
		break;
		case 3:		// Three hits found -> coincidence order =1
			if((abs(time[0]-time[1])>deadtime) || (abs(time[2]-time[1])>deadtime)) return 0; 
			*(nTimeGroups) = 1;
			for(xm=0, ym=0,i=0;i<3;i++) {
				if(channelx[i]!=0)	xm+=channelx[i];
				if(channely[i]!=0)	ym+=channely[i];
			}
			xMoyen[0]=xm/((float)nx); 
			yMoyen[0]=ym/((float)ny); 
			MeanTimeofGroup[0] = (float)(time[0]+time[1]+time[2])/3;
			XYDetector->nbHits[*(nTimeGroups)][nxy]+=1;		// Save hit distribution
		break;	
		default:	// Many hits found
			scqs3(nxy,time,channelx,channely);  // Sort hits vs time
			*(nTimeGroups) = analyzeXYEvent(Detector);
			if ((*(nTimeGroups)>0)&&(*(nTimeGroups)<MAXCOINCIDENCEORDER)) //-> coincidence order>0 and not too high
				XYDetector->nbHits[*(nTimeGroups)][nxy]+=1;	// Save hit distribution 
			else 
				return 0; 		// Problem in localization*/
		break;
	
	}
	// quick sort with respect to the arrival time and quit
	// if(*(nTimeGroups) >1)	scqs3(*(nTimeGroups), MeanTimeofGroup, xMoyen, yMoyen); // Could be useless ?? 
	return *(nTimeGroups);
	
}

//-----------------------------------------------------------------------------------------------------------------------------
static short analyzeXYEvent(TDetector *Detector)  /// PASSAGE EN MILLIMETRE
{
  	float *tm = Detector->MeanTimeofGroup;		 	  
 	float *xm = Detector->xMoyen;
	float *ym = Detector->yMoyen;
	
	TXYDetector *XYDetector=(TXYDetector*)Detector->device;	
	long  maxi = XYDetector->nbDS16*16;
	long deltaT = XYDetector-> deltaT;
	long lostpixel = XYDetector->lostpixel; // Number of neighbouring lines missing due to dead channel of DS16...

	TXYEvent *Event = &XYDetector->Event;	
  	long nhits	= Event->nxy;
 	long *t	= Event->time;
 	long *x = Event->channelx;
 	long *y = Event->channely;	
	
	long i=0, ok=0, error=0, init=1, mygroup=0;
	long xmin, xmax, xi, nbx, dx;
	long ymin, ymax, yi, nby, dy;
	int tt, ti, nbt;
	float tg;
	
	do {		// Main loop		
		xi=x[i];
		yi=y[i];
		ti=t[i];
		if (init) { // Initialization for the firs hit in a group			
			tg=ti;tt=ti;nbt=1;
			if (xi) 
				{xmin=xi;xmax=xmin;nbx=1;}
			else 
				{xmin=maxi;xmax=0;nbx=0;}
			if (yi) 
				{ymin=yi;ymax=ymin;nby=1;}
			else 
				{ymin=maxi;ymax=0;nby=0;}
			init=0;
			}			
		else {// Check if the other hits are inside the same time group
			if (fabs(ti-tg)<=deltaT) { //if yes determine min and max in X and Y
					if (xi) {
						nbx++;
						if (xmin>xi) xmin=xi;
						if (xmax<xi) xmax=xi;
					}
					if (yi) {
						nby++;
						if (ymin>yi) ymin=yi;
						if (ymax<yi) ymax=yi;
					}
					tt+=ti;nbt++;tg=(float)tt/nbt;
				}
			else { // if no save the previous group if it is good or exit
					dx=abs(xmax-xmin-nbx+1); if (dx>lostpixel) error=1;
					dy=abs(ymax-ymin-nby+1); if (dy>lostpixel) error=1;
					if ((nbt<1)||(nbx<1)||(nby<1)) error=1;
					if (!error) {
						xm[mygroup]=(float)(xmax+xmin)/2;
						ym[mygroup]=(float)(ymax+ymin)/2;
						tm[mygroup]=(float)tt/nbt;
						mygroup++;
						if (mygroup>MAXCOINCIDENCEORDER) return MAXCOINCIDENCEORDER;
					}
					init=1;	 //prepare to initialize the next group
			}
		}
		i++;
		ok=(i<nhits)&&(!error);
	} while (ok);
	
	if (!error) {
		dx=abs(xmax-xmin-nbx+1); if (dx>lostpixel) error=1;
		dy=abs(ymax-ymin-nby+1); if (dy>lostpixel) error=1;
		if ((nbt<1)||(nbx<1)||(nby<1)) error=1;
	}
	if (!error) {	
		xm[mygroup]=(float)(xmax+xmin)/2;
		ym[mygroup]=(float)(ymax+ymin)/2;
		tm[mygroup]=(float)tt/nbt;
		mygroup++;
	}

	if (mygroup>MAXCOINCIDENCEORDER) return MAXCOINCIDENCEORDER;
	return mygroup;
}

#pragma mark ----------------------------
//-----------------------------------------------------------------------------------------------------------------------------
short createXYDetector(TDetector *Detector, long nbDS16, long anode, long deltaT, long lostpixel, float pixelsize, long ref, long ch1, long ch2)
{
	TXYDetector *XYDetector=NULL;
	TXYEvent 	*Event;
	int 		nbChannel=16*nbDS16;
	
	XYDetector=(TXYDetector*)malloc(sizeof(TXYDetector));
	if (!XYDetector) return 1;
	Detector->device=XYDetector;
	Event=&XYDetector->Event;
	
	XYDetector->nbDS16=nbDS16;
	XYDetector->anode=anode;	
	XYDetector->deltaT=deltaT;
	XYDetector->lostpixel=0;

	XYDetector->ref=ref;
	XYDetector->ch[0]=ch1;
	XYDetector->ch[1]=ch2;
	
	XYDetector->pixelsize=pixelsize;
	
	Event->numDS16Bits=(nbDS16-1)<<4;
	Event->xyBit=nbChannel/2;
	Event->numChannelBits=nbChannel/2-1;
	
	MemClear(XYDetector->channelOffset, sizeof(XYDetector->channelOffset));
	MemClear(XYDetector->DS16Offset, sizeof(XYDetector->DS16Offset));
	
	return 0;
}

//----------------------------------------------------------------------------------------------------------------------------- 
short updateXYDetector(TDetector *Detector, int mode)
{
	TXYDetector *XYDetector=(TXYDetector*)Detector->device;	
	waveHndl		w;
	DOUBLE val1, val2;	
	long numRows=0, numColumns=0;
	int i, error=0, flags = OVERWRITE;
	char s[100];
	
	// A revoir... 
	switch (mode) {
		case CREATE:
				MemClear(XYDetector->DS16Area, sizeof(XYDetector->DS16Area));
				MemClear(XYDetector->nbHits, sizeof(XYDetector->nbHits));	
				// Hits distribution for each order of coincidence
				for (i=1;i<MAXCOINCIDENCEORDER;i++) {	
					sprintf(s,"nHits%i",i);	 
					if (error=MakeAWave(s, flags, &w,  N_HITS_MAX, 1, NT_I32)) return error;
					sprintf(s,"nHits%i=0;",i);
					if (error=XOPSilentCommand(s)) return error;
				}				

			break;

		case ADD:
			
				// Hits distribution for each order of coincidence
				numRows=N_HITS_MAX;
				for (i=1;i<MAXCOINCIDENCEORDER;i++) {	
					sprintf(s,"nHits%i",i);	 
					if (error=CheckWave(s, &w, &numRows, &numColumns)) return error;
				}
				// Get Area per DS16 
  				for (i=0; i<XYDetector->nbDS16; i++) {			
  					sprintf(s,"DS16Area_%i",i);
  					if (FetchNumVar(s,&val1,&val2)==-1) {
  					if (error = SetIgorIntVar(s,XYDetector->DS16Area[i],1)) return error;
  					}
  					else XYDetector->DS16Area[i]=(long)val1;
  			  		
  				}				
			break;

		case END_OF_ACQUISITION:	
				// Hits distribution for each order of coincidence
				for (i=1;i<MAXCOINCIDENCEORDER;i++) { 
					sprintf(s,"nHits%i",i);
					if (error=AddTable2IgorWave(s,XYDetector->nbHits[i],N_HITS_MAX,1)) return error;
				}					
				// Set Area per DS16 
  				for (i=0; i<XYDetector->nbDS16; i++) {			
  					sprintf(s,"DS16Area_%i",i);
  					if (error = SetIgorIntVar(s,XYDetector->DS16Area[i],1)) return error;  			  		
  				}
  				if (XYDetector) {
  					free(XYDetector);	
  					XYDetector=NULL;
  					}			
			break;
			}
return error;
}
			
//-----------------------------------------------------------------------------------------------------------------------------
short setigorXYDetector(TDetector *Detector)
{
	TXYDetector *XYDetector=(TXYDetector*)Detector->device;
	TXYEvent *Event=&XYDetector->Event;
	long i, j,indices[MAX_DIMENSIONS], error=0;
	DOUBLE values[2]={0,0};
	char name[100];
	waveHndl w;

	MemClear(indices, sizeof(indices));
	
  	// Create Igor variables for the XY detector

	if (error = SetIgorIntVar("nbDS16",XYDetector->nbDS16,1)) 		return error;   // Number of DS16 for this detector
  	if (error = SetIgorIntVar("anode",XYDetector->anode,1)) 			return error;	// Type of anode: nested, or not nested
	if (error = SetIgorIntVar("deltaT",XYDetector->deltaT,1)) 		return error; 	// recognition time (nb channel)	
	if (error = SetIgorIntVar("lostpixel",XYDetector->lostpixel,1)) 	return error;	// number of pixel w.r.t. the closest neightbour
  	if (error = SetIgorFloatingVar("pixelsize",&XYDetector->pixelsize,1)) return error;		// pixel size;
	
  	if (error = SetIgorIntVar("ref",XYDetector->ref,1)) 	return error;			// Time reference channel (ch1, ch2, or ch1&ch2...)
  	if (error = SetIgorIntVar("ch1",XYDetector->ch[0],1)) return error;			// channel number
  	if (error = SetIgorIntVar("ch2",XYDetector->ch[1],1)) return error;			// channel number 	

	// Create for each DS16 : offset table and area table
  	for (i=0; i<XYDetector->nbDS16; i++) {
  		// Offset
  		sprintf(name,"DS16Offset_%i",i);
  		if (error = SetIgorIntVar(name,XYDetector->DS16Offset[i],1)) return error;
 		// Area
 		sprintf(name,"DS16Area_%i",i);
   		if (error = SetIgorIntVar(name,XYDetector->DS16Area[i],1)) return error;
  	}
  	
	// Create Igor waves for the detector
  	if (error= MakeAWave("channelOffset",OVERWRITE,&w,16,XYDetector->nbDS16,NT_I32)) return error;	 // offset per channel	
  	for (i=0; i<16; i++) { 
  		indices[0]=i;
  		for (j=0;j<XYDetector->nbDS16;j++) {
  			indices[1]=j;
  			values[0]=XYDetector->channelOffset[i][j];  			
  			if (error = MDSetNumericWavePointValue(w, indices, values)) return error;
  				}
  		}
  	return error;
}

//-----------------------------------------------------------------------------------------------------------------------------
short getigorXYDetector(TDetector *Detector)
{
	TXYDetector *XYDetector;
	TXYEvent 	*Event;
	waveHndl w;

	long 	i, j, indices[MAX_DIMENSIONS];
	DOUBLE 	val1, val2, values[2]={0,0};
	int 	nbChannel, error=0;	
	char name[255];
		
 	XYDetector=(TXYDetector*)malloc(sizeof(TXYDetector));
	if (!XYDetector) return 1;
	Detector->device=XYDetector;
	Event=&XYDetector->Event;
	 	
  	// Anode
  	
 	MemClear(indices, sizeof(indices));
 	
    if (FetchNumVar("nbDS16",&val1,&val2)==-1) { 
  		if (error = SetIgorIntVar("nbDS16",XYDetector->nbDS16,1)) return error;
  		} 
  	else XYDetector->nbDS16=(long)val1;
  
	if (FetchNumVar("anode",&val1,&val2)==-1) { 
  		if (error = SetIgorIntVar("anode",XYDetector->anode,1)) return error;
  		} 
  	else XYDetector->anode=(long)val1;
  	
    if (FetchNumVar("deltaT",&val1,&val2)==-1) { 
  		if (error = SetIgorIntVar("deltaT",XYDetector->deltaT,1)) return error;
  		}
  	else XYDetector->deltaT=(long)val1; 
  	  		  
   	if (FetchNumVar("lostpixel",&val1,&val2)==-1) { 
  		if (error = SetIgorIntVar("lostpixel",XYDetector->lostpixel,1)) return error;
  		}
  	else XYDetector->lostpixel=(long)val1; 	

   	if (FetchNumVar("pixelsize",&val1,&val2)==-1) {  // Get pixel size;
  		if (error = SetIgorFloatingVar("pixelsize",&XYDetector->pixelsize,1)) return error;
  		}
  	else XYDetector->pixelsize=(long)val1;	
   	 	
  	// Time reference channel
  	if (FetchNumVar("ref",&val1,&val2)==-1) { 
  		if (error = SetIgorIntVar("ref",XYDetector->ref,1)) return error;
  		}
  	else XYDetector->ref=(long)val1;
  	
  	if (FetchNumVar("ch1",&val1,&val2)==-1) { 
  		if (error = SetIgorIntVar("ch1",XYDetector->ch[0],1)) return error;
  		}
  	else XYDetector->ch[0]=(long)val1;
  	
  	if (FetchNumVar("ch2",&val1,&val2)==-1) { 
  		if (error = SetIgorIntVar("ch2",XYDetector->ch[1],1)) return error;
  		}
  	else XYDetector->ch[1]=(long)val1;
  	
  	
	// Get for each DS16 : offset table and area table
  	for (i=0; i<XYDetector->nbDS16; i++) {
  		// Offset per DS16
  		sprintf(name,"DS16Offset_%i",i);
  		if (FetchNumVar(name,&val1,&val2)==-1) {
  			if (error = SetIgorIntVar(name,XYDetector->DS16Offset[i],1)) return error;
  			}
  		else XYDetector->DS16Offset[i]=(long)val1;	
  		
  		// Area per DS16
  		sprintf(name,"DS16Area_%i",i);
  		if (FetchNumVar(name,&val1,&val2)==-1) {
  			if (error = SetIgorIntVar(name,XYDetector->DS16Area[i],1)) return error;
  			}
  		else XYDetector->DS16Area[i]=(long)val1;
  			  		
  	}
  	
  	// Get Time offset per channel  	
  	w= FetchWave("channelOffset");		
   	if (w==NULL) {
  		if (error= MakeAWave("channelOffset",OVERWRITE,&w,16,XYDetector->nbDS16,NT_I32)) return error;
  		}
  	else {
  		for (i=0; i<16; i++) {
  			indices[0]=i;
  			for (j=0;j<XYDetector->nbDS16;j++) {
  				indices[1]=j;						
  				if (error = MDGetNumericWavePointValue(w, indices, values)) return error;
  				XYDetector->channelOffset[i][j]=(long)values[0];  
  			} 
  		}
  	}
  	nbChannel=XYDetector->nbDS16*16;
	Event->numDS16Bits=(XYDetector->nbDS16-1)<<4;
	Event->xyBit=nbChannel/2;
	Event->numChannelBits=nbChannel/2-1;
	
	return error;	
 }

//-----------------------------------------------------------------------------------------------------------------------------
#pragma mark ----------------------------
//-----------------------------------------------------------------------------------------------------------------------------
// All structures are 2-byte-aligned.
#if TARGET_CPU_PPC
	#pragma options align=reset
#endif
#ifdef _WINDOWS_
	#pragma pack()
#endif
